<?php
class Reservation extends MY_Controller
{
    public $module_name;
    public function __construct()
    {

        parent::__construct();
        $this->module_name = $this->router->fetch_module();
        $this->load->model('../extensions/'.$this->module_name.'/models/Company_model');
        $this->load->model('../extensions/'.$this->module_name.'/models/Room_model');
        // $this->load->model('../extensions/'.$this->module_name.'/models/Booking_model');
        $this->load->model('../extensions/'.$this->module_name.'/models/Reservation_booking_model');
        $this->load->model('../extensions/'.$this->module_name.'/models/Customer_field_model');
        $this->load->model('../extensions/'.$this->module_name.'/models/Customer_model');
        $this->load->model('../extensions/'.$this->module_name.'/models/Whitelabel_partner_model');
        $this->load->model('../extensions/'.$this->module_name.'/models/Booking_source_model');
        $this->load->model('../extensions/'.$this->module_name.'/models/Booking_field_model');
        $this->load->library('session');
        $view_data['menu_on'] = true;
        $this->load->vars($view_data);
    }

    /*
     * Get all reservation reports to view
     * */
    public function show_reservation_report($from_date = null, $to_date = null, $state = ALL)
    {   
        
        //get user's shift information
        $date = (isset($from_date)) ? $from_date : $this->selling_date;
        $from_date = (isset($from_date)) ? $from_date : date('Y-m-01');
        $to_date = (isset($to_date)) ? $to_date : date('Y-m-d', strtotime($from_date . '+1 month'));
        $data['date'] = $date;
        $data['from_date'] = $from_date;
        $data['to_date'] = $to_date;
        $data['state_value'] = $state;
        $data['hotel_name'] = $this->company_name;

        $filters = array(
            'start_date' => $from_date,
            'end_date' => $to_date,
            'order_by' => $this->session->userdata('reservation_order_by'),
            'order' => $this->session->userdata('reservation_order'),
        );

        $data['selected_state'] = $state;
        if ($state == -1) {
            $filters['state'] = "active";
        } else {
            $filters['state'] = $state;
        }

        $filters['include_customer_type'] = true;
        $filters['include_booking_fields'] = true;

        $company_id = $this->session->userdata('current_company_id');
        $data['bookings'] = $this->Reservation_booking_model->get_bookings_for_report($filters, 0, null, true);
        $company_partner_id = isset($this->company_partner_id) && $this->company_partner_id ? $this->company_partner_id : 1;
        $data['partner'] = $this->Whitelabel_partner_model->get_partner_detail($company_partner_id);

        $data['company_details'] = $this->Company_model->get_company($company_id);

        $data['common_customer_fields'] = $this->Customer_field_model->get_common_customer_fields_settings($this->company_id);
        $data['customer_common_fields'] = json_decode(COMMON_CUSTOMER_FIELDS, true);

        $common_customer_fields = json_decode(COMMON_CUSTOMER_DB_FIELDS, true);
        foreach ($data['customer_common_fields'] as $key => $field) {
            $data['common_customer_fields'][$key]['name'] = $field;
        }

        $booking_sources = array();

        $common_booking_sources = json_decode(COMMON_BOOKING_SOURCES, true);

        $data['custom_booking_sources'] = $this->Booking_source_model->get_booking_source($this->company_id);
        foreach ($common_booking_sources as $key => $field) {
            $booking_source[$key] = $field;
        }

        if(isset($data['custom_booking_sources']) && $data['custom_booking_sources']){
            foreach ($data['custom_booking_sources'] as $key => $field) {
                $booking_source[$field['id']] = $field['name'];
            }
        }
        

        $data['common_booking_sources'] = $booking_source;

        $room_types = $this->Room_model->get_all_room_types($company_id);
        $r_types = $room_array = array();

        foreach ($room_types as $key => $room_type) {
            $room_array[$room_type['room_id']] = $room_type['name'];
            $r_types[$room_type['room_type_id']] = $room_type['name'];
        }

        $cached_customer_fields = [];

        foreach ($data['bookings'] as $key => $booking) {
            $data['bookings'][$key]['r_name'] = $booking['room_id'] ? $room_array[$booking['room_id']] : $r_types[$booking['brh_room_type_id']];

            if (isset($cached_customer_fields[$booking['booking_customer_id']])) {
                $data['bookings'][$key]['customer_fields'] = $cached_customer_fields[$booking['booking_customer_id']];
            } else {
                $data['bookings'][$key]['customer_fields'] = isset($booking['booking_customer_id']) ? $this->Customer_model->get_customer_fields($booking['booking_customer_id']) : null;
                $cached_customer_fields[$booking['booking_customer_id']] = $data['bookings'][$key]['customer_fields'];
            }

            // foreach ($data['common_customer_fields'] as $id => $field) {
            //     if (isset($field['show_on_in_house_report']) && $field['show_on_in_house_report']) {
            //         $data['bookings'][$key]['customer_common_fields'][$id] = (isset($data['bookings'][$key][$common_customer_fields[$id]]) && $data['bookings'][$key][$common_customer_fields[$id]]) ? $data['bookings'][$key][$common_customer_fields[$id]] : '';
            //     }
            // }


            // $staying_customer_ids = explode(',', $data['bookings'][$key]['staying_customer_id']);

            // foreach ($staying_customer_ids as $key1 => $customer_id) {
            //     $customer_id = trim($customer_id, " ");
            //     $cust_ids = null;
            //     if (isset($cached_customer_fields[$customer_id])) {
            //         $cust_ids = $cached_customer_fields[$customer_id];
            //     } else {
            //         $cust_ids = isset($customer_id) ? $this->Customer_model->get_customer_fields($customer_id) : null;
            //         $cached_customer_fields[$customer_id] = $cust_ids;
            //     }

            //     if ($cust_ids) {
            //         foreach ($cust_ids as $key2 => $val2) {
            //             $data['bookings'][$key]['customer_fields'][$key2] = (($cust_ids[$key2]) ? $data['bookings'][$key]['customer_fields'][$key2] . ',' . $cust_ids[$key2] : (isset($data['bookings'][$key]['customer_fields'][$key2]) && ($data['bookings'][$key]['customer_fields'][$key2]) ? $data['bookings'][$key]['customer_fields'][$key2] : ''));
            //         }
            //     }
            // }





            foreach ($data['common_customer_fields'] as $id => $field) {
                if (isset($field['show_on_in_house_report']) && $field['show_on_in_house_report']) {
                    $data['bookings'][$key]['customer_common_fields'][$id] = 
                        (!empty($data['bookings'][$key][$common_customer_fields[$id]])) 
                        ? $data['bookings'][$key][$common_customer_fields[$id]] 
                        : '';
                }
            }

            $staying_customer_ids = explode(',', $data['bookings'][$key]['staying_customer_id']);

            foreach ($staying_customer_ids as $customer_id) {
                $customer_id = trim($customer_id);
                if (!$customer_id) continue;

                if (isset($cached_customer_fields[$customer_id])) {
                    $cust_ids = $cached_customer_fields[$customer_id];
                } else {
                    $cust_ids = $this->Customer_model->get_customer_fields($customer_id);
                    $cached_customer_fields[$customer_id] = $cust_ids;
                }

                if ($cust_ids) {
                    foreach ($cust_ids as $key2 => $val2) {
                        // make sure it's always an array
                        if (!isset($data['bookings'][$key]['customer_fields'][$key2])) {
                            $data['bookings'][$key]['customer_fields'][$key2] = [];
                        } elseif (!is_array($data['bookings'][$key]['customer_fields'][$key2])) {
                            $data['bookings'][$key]['customer_fields'][$key2] = 
                                [$data['bookings'][$key]['customer_fields'][$key2]];
                        }

                        if (!in_array($val2, $data['bookings'][$key]['customer_fields'][$key2])) {
                            $data['bookings'][$key]['customer_fields'][$key2][] = $val2;
                        }
                    }
                }
            }

            // Convert arrays to comma-separated strings (unique values only)
            if (isset($data['bookings'][$key]['customer_fields'])) {
                foreach ($data['bookings'][$key]['customer_fields'] as $fieldKey => $vals) {
                    if (is_array($vals)) {
                        $data['bookings'][$key]['customer_fields'][$fieldKey] = implode(', ', array_unique($vals));
                    }
                }
            }

            $booking_fields_values = explode(',', $data['bookings'][$key]['booking_custom_field_value']);

            $booking_fields_ids = explode(',', $data['bookings'][$key]['booking_field_id']);

            $booking_custom_fields_array = array();

            for ($i = 0; $i < count($booking_fields_ids); $i++) {
                $booking_custom_fields_array[trim($booking_fields_ids[$i])] = isset($booking_fields_values) && isset($booking_fields_values[$i]) &&
                $booking_fields_values && $booking_fields_values[$i] ? trim($booking_fields_values[$i]) : '';
            }
            $data['bookings'][$key]['booking_custom_fields'] = $booking_custom_fields_array ? $booking_custom_fields_array : null;

            // specific requirement from Cirque du Soleil Résidence hotel - overlaping days from both periods is No of Days.
            
            $date1 = date_create(date("Y-m-d", strtotime($booking['check_in_date'])));
            $date2 = date_create(date("Y-m-d", strtotime($booking['check_out_date'])));
            $no_of_days = date_diff($date1, $date2);
            $data['bookings'][$key]['no_of_days'] = $no_of_days->format("%a");
          

            // start for get the sub total, tax total and grand total charges

            if($company_id == 2733) {

                $booking_id = $booking['booking_id'];
                if(
                    $booking['rate'] != 0 || 
                    $booking['balance'] != 0 || 
                    $booking['balance_without_forecast'] != 0
                ) {

                    $charges  = $this->Charge_model->get_charges($booking_id);

                    // echo $booking_id. ' - '.strtotime($this->selling_date). ' - ' .strtotime(date("Y-m-d", strtotime($booking['check_out_date'])));
                    // echo "<br/>";
                    if(strtotime($this->selling_date) <= strtotime(date("Y-m-d", strtotime($booking['check_out_date'])))) {

                        // and invoice currently viewing transactions for 'booking customer'
                        if(!$data['company_details']['hide_forecast_charges'])
                        {
                            if (($booking['booking_customer_id'] == $customer_id || $customer_id == false))
                            {
                                $charges = array_merge($charges, $this->forecast_charges->_get_forecast_charges($booking_id, false));
                                $charges = array_merge($charges, $this->forecast_charges->_get_forecast_extra_charges($booking_id, false));
                                if(isset($data['folios'][0])) {
                                    $data['folios'][0]['charge_count'] = count($charges);
                                }
                            }
                            elseif(isset($data['folios'][0]))
                            {
                                $forecast_charges = $this->forecast_charges->_get_forecast_charges($booking_id);
                                $forecast_charges = array_merge($forecast_charges, $this->forecast_charges->_get_forecast_extra_charges($booking_id, false));
                                $data['folios'][0]['charge_count'] = count($forecast_charges);
                            }
                        }
                    }

                    // assign taxes to charges
                    $taxes_cache = array();
                    foreach ($charges as $index => $charge) {
                        if (isset($taxes_cache[$charge['charge_type_id'] .'-'. $charge['amount']])) {
                            $charges[$index]['taxes'] = $taxes_cache[$charge['charge_type_id'] .'-'. $charge['amount']];
                        } else {
                            $charges[$index]['taxes'] = $this->Charge_type_model->get_taxes($charge['charge_type_id'], $charge['amount']);
                            $taxes_cache[$charge['charge_type_id'] .'-'. $charge['amount']] = $charges[$index]['taxes'];
                        }
                    }
                    $taxes_cache = array(); // release memory

                }
                
                // $data['charges']  = $charges;
                $payments = $this->Reservation_booking_model->get_payments($booking_id, $customer_id);
                if($payments){
                    $total_amount = 0;
                    foreach($payments as $index => $payment){
                        $payments[$index]['remaining_amount'] = '';
                        if($payment['payment_status'] == 'charge' ||$payment['payment_status'] == NULL ){
                            $total_amount = $payment['amount'];
                            $charge_id = $payment['gateway_charge_id'];
                            $partial_payments = isset($charge_id) ? $this->Reservation_booking_model->get_partial_refunds_by_charge_id($charge_id) : null;

                            $total_partial_amount = 0;
                            if(!empty($partial_payments)){
                                foreach($partial_payments as $partial_payment){
                                    $total_partial_amount += $partial_payment['amount'];
                                }
                                $payments[$index]['remaining_amount'] = $total_amount + $total_partial_amount;
                            }
                        }
                    }
                }

                $data['bookings'][$key]['payments'] = $payments;

                $charge_sub_total = $charge_tax_total = $charge_final_total = 0;

                if (isset($charges)):
                    foreach($charges as $charge):
                        $rate = (float)$charge['amount'];
                        // $charge_sub_total += (float)$charge['amount'];

                        $combined_tax = 0;

                        if (isset($charge['taxes'])) {
                            foreach ($charge['taxes'] as $tax) {
                                if ($tax['is_percentage'] == 1)
                                {
                                    if($tax['is_tax_inclusive'] == 1)
                                    {
                                        $tax_amount = (float)$charge['amount'] - ($rate / (1 + ((float)$tax['tax_rate'] * 0.01)));
                                        $combined_tax = $combined_tax;
                                    }
                                    else
                                    {
                                        $tax_amount = (float)$tax['tax_rate'] * $rate * 0.01;
                                        $combined_tax = $combined_tax + $tax_amount;
                                    }
                                }
                                else
                                {
                                    $tax_amount = (float)$tax['tax_rate'];
                                    $combined_tax = $combined_tax + $tax_amount;
                                }

                                $charge_tax_total += number_format($tax_amount, 2, ".", ",");
                            }
                        }

                        $charge_final_total += number_format($rate + $combined_tax, 2, ".", ",");

                    endforeach;
                endif;

                $data['bookings'][$key]['charge_sub_total'] = $charge_final_total - $charge_tax_total;
                $data['bookings'][$key]['charge_tax_total'] = $charge_tax_total;
                $data['bookings'][$key]['charge_final_total'] = $charge_final_total;

            }

            // end for get the sub total, tax total and grand total charges

        }

        // prx($data);
        $data['customer_fields'] = $this->Customer_field_model->get_customer_fields($company_id);

        $data['booking_fields'] = $this->Booking_field_model->get_booking_fields($company_id);

        $data['js_files'] = array(
            base_url() . 'js/moment.min.js',
        );
        
        $data['main_content'] = '../extensions/' . $this->module_name . '/views/reservation_report';

        $this->template->load('bootstrapped_template', null, $data['main_content'], $data);

    }

    public function show_reservation_report_cm($from_date = null, $to_date = null, $state = ALL, $booking_source = -1)
    {
        //get user's shift information
        $date = (isset($from_date)) ? $from_date : $this->selling_date;
        $from_date = (isset($from_date)) ? $from_date : date('Y-m-01');
        $to_date = (isset($to_date)) ? $to_date : date('Y-m-d', strtotime($from_date . ' +1 month'));
        $data['date'] = $date;
        $data['from_date'] = $from_date;
        $data['to_date'] = $to_date;
        $data['state_value'] = $state;
        $data['booking_source'] = $booking_source;
        $data['hotel_name'] = $this->company_name;

        if (!is_null($booking_sources = $this->Booking_source_model->get_booking_source($this->company_id, false, true))) {
            $data['booking_sources'] = $booking_sources;
        }

        $common_booking_sources = json_decode(COMMON_BOOKING_SOURCES, true);
        $sort_order = 0;
        $coomon_sources_setting = $this->Booking_source_model->get_common_booking_sources_settings($this->company_id);
        foreach ($common_booking_sources as $id => $name) {
            $data['booking_sources'][] = array(
                'id' => $id,
                'name' => $name,
                'company_id' => $this->company_id,
                'is_deleted' => 0,
                'is_common_source' => true,
                'is_hidden' => isset($coomon_sources_setting[$id]) ? $coomon_sources_setting[$id]['is_hidden'] : 0,
                'sort_order' => isset($coomon_sources_setting[$id]) ? $coomon_sources_setting[$id]['sort_order'] : $sort_order,
            );
            $sort_order++;
        }

        $filters = array(
            'start_date' => $from_date,
            'end_date' => $to_date,
            'booking_source' => $booking_source,
            'is_channel_manager' => 1,
            'order_by' => $this->session->userdata('reservation_order_by'),
            'order' => $this->session->userdata('reservation_order'),
        );

        $data['selected_state'] = $state;
        if ($state == -1) {
            $filters['state'] = "active";
        } else {
            $filters['state'] = $state;
        }

        $data['selected_source'] = $booking_source;
        if ($booking_source == -1) {
            $filters['booking_source'] = "active";
        } else {
            $filters['booking_source'] = $booking_source;
        }

        $room_types = $this->Room_model->get_all_room_types($this->company_id);
        $r_types = $room_array = array();
        foreach ($room_types as $key => $room_type) {
            $room_array[$room_type['room_id']] = $room_type['name'];
            $r_types[$room_type['room_type_id']] = $room_type['name'];
        }

        $company_id = $this->session->userdata('current_company_id');
        $data['bookings'] = $this->Reservation_booking_model->get_bookings_for_report($filters);
        foreach ($data['bookings'] as $key => $booking) {

            $supplied_rate = 0;
            if ($booking['use_rate_plan'] == 1) {
                $rate_array = $this->ci->rate->get_rate_array($booking['rate_plan_id'], $booking['check_in_date'], $booking['check_out_date']);
                foreach ($rate_array as $index => $rate) {
                    if ($booking['adult_count'] >= 1 && $booking['adult_count'] <= 4) {
                        $supplied_rate += ($rate['supplied_adult_' . $booking['adult_count'] . '_rate']);
                    } else {
                        $supplied_rate += ($rate['supplied_adult_2_rate']);
                    }
                }
            }
            $data['bookings'][$key]['supplied_rate'] = $supplied_rate;

            // get room type name
            $data['bookings'][$key]['r_name'] = $booking['room_id'] ? $room_array[$booking['room_id']] : $r_types[$booking['brh_room_type_id']];
        }

        $company_partner_id = isset($this->company_partner_id) && $this->company_partner_id ? $this->company_partner_id : 1;
        $data['partner'] = $this->Whitelabel_partner_model->get_partner_detail($company_partner_id);

        $feature_name = 'hide_decimal_places';
        $features = $this->Company_model->get_company($this->company_id);
        $feature = $feature_name && isset($features[$feature_name]) ? $features[$feature_name] : "";

        $data['show_decimal'] = (isset($feature) && $feature) ? false : true;

        $data['js_files'] = array(
            base_url() . 'js/moment.min.js',
        );
        
        $data['main_content'] = '../extensions/' . $this->module_name . '/views/reservation_report_cm';
        $this->template->load('bootstrapped_template', null, $data['main_content'], $data);
    }

    public function download_csv_export($from_date = null, $to_date = null, $state = ALL, $booking_source = -1, $is_cm_partner = false)
    {
        $from_date = (isset($from_date)) ? $from_date : date('Y-m-01');
        $to_date = (isset($to_date)) ? $to_date : date('Y-m-d', strtotime($from_date . ' +1 month'));

        $this->load->helper('download');
        $this->load->helper('customer_name');

        $filters = array(
            'start_date' => $from_date,
            'end_date' => $to_date,
            'booking_source' => $booking_source,
            'order_by' => $this->session->userdata('reservation_order_by'),
            'order' => $this->session->userdata('reservation_order'),
        );

        if ($is_cm_partner) {
            $filters['is_channel_manager'] = 1;
        }

        if ($state == -1) {
            $filters['state'] = "active";
        } else {
            $filters['state'] = $state;
        }

        $filters['include_customer_type'] = true;
        $filters['include_booking_fields'] = true;
        $data['bookings'] = $this->Reservation_booking_model->get_bookings_for_report($filters, 0, null, true);
        $common_booking_sources = json_decode(COMMON_BOOKING_SOURCES, true);
        
        // PREPARE KEY FOR THE CSV
        $company_id = $this->session->userdata('current_company_id');
        $company_details = $this->Company_model->get_company($company_id);
        $customer_fields = $this->Customer_field_model->get_customer_fields($company_id);
        $reservation_settings = $company_details['reservation_settings'];
        if ($reservation_settings == "") {
            // $reservation_settings = "created_date,booking_id,status,room,check_in_date,check_out_date,customer_names,customer_email,customer_notes";
            $reservation_settings = "created_date,booking_id,status,room,no_of_days,check_in_date,check_out_date,customer_names,email,phone,customer_notes,customer_type";
        }
        $settings = explode(',', $reservation_settings);
        $csv_keys = [];

        $csv_lookup_keys = array(
            "created_date" => "Creation Date",
            "check_in_date" => "Check-in date",
            "check_out_date" => "Check-Out date",
            "booking_id" => "Booking Id",
            "balance" => "Balance",
            "customer_name" => "Guest Name",
            "email" => "Guest Email",
            "phone" => "Guest Phone",
            "address" => "Guest Address",
            "state" => "Guest State",
            "city" => "Guest City",
            "postal_code" => "Guest Postal Code",
            "country" => "Guest Country",
            "room" => "Room",
            "no_of_days" => "No Of Days",
            "adult_count" => "Number of Adults",
            "children_count" => "Number Of Children",
            "booking_source" => "Booking Source",
            "ota_confirmtion" => "OTA Confirmation",
            "booked_by" => "Booked By",
            "rate" => "Rate",
            "rate_plan" => "Rate plan",
            "status" => "Status",
            "booking_notes_desc" => "Booking Notes",
            "customer_type" => "Customer Type",
            "total_reservation_amount" => "Total Reservation Amount",
            "paid_amount" => "Paid Amount"
            // "charge_sub_total" => "Charge Sub Total",
            // "charge_tax_total" => "Charge Tax Total",
            // "charge_final_total" => "Grand Total",
            // "payment_method" => "Payment Method"
        );

        if($company_id == 2733) {
            $csv_lookup_keys['charge_sub_total'] = "Charge Sub Total";
            $csv_lookup_keys['charge_tax_total'] = "Charge Tax Total";
            $csv_lookup_keys['charge_final_total'] = "Grand Total";
            $csv_lookup_keys['payment_method'] = "Payment Method";
        }


        foreach($csv_lookup_keys as $key => $value) {
           if(in_array($key,$settings)){
               $csv_keys[] = $value;
           }
        }
        

        // CUSTOMER FIELDS
        $data['common_customer_fields'] = $this->Customer_field_model->get_common_customer_fields_settings($this->company_id);
        $data['customer_common_fields'] = json_decode(COMMON_CUSTOMER_FIELDS, true);

        $common_customer_fields = json_decode(COMMON_CUSTOMER_DB_FIELDS, true);
        foreach ($data['customer_common_fields'] as $key => $field) {
            $data['common_customer_fields'][$key]['name'] = $field;
        }

        krsort($data['common_customer_fields']);

        if (count($data['common_customer_fields']) != 0) {
            foreach ($data['common_customer_fields'] as $fields) {
                if (isset($fields['show_on_in_house_report']) && $fields['show_on_in_house_report'] == 1
                    && !in_array($fields['name'], ['Notes', 'Name', 'Customer Type'])
                    && in_array(preg_replace("/^'|[^A-Za-z0-9\'-]|'?/", '', $fields['name']), $settings)
                ) {
                    $csv_keys[] = $fields['name'];
                }
            }
        }

        // CUSTOMER FIELDS
        if (isset($customer_fields) && count($customer_fields) != 0) {
            foreach ($customer_fields as $fields) {
                if ($fields['show_on_in_house_report'] == 1 && in_array(preg_replace("/^'|[^A-Za-z0-9\'-]|'?/", '', $fields['name']), $settings)) {
                    $csv_keys[] = $fields['name'];
                }
            }
        }

        // BOOKING FIELDS
        $booking_fields = $this->Booking_field_model->get_booking_fields($company_id);
        if (isset($booking_fields) && count($booking_fields) != 0) {
            foreach ($booking_fields as $fields) {
                if (in_array(preg_replace("/^'|[^A-Za-z0-9\'-]|'?/", '', $fields['name']), $settings)) {
                    $csv_keys[] = $fields['name'];
                }
            }
        }

        $bookings = array($csv_keys);
     
        // PREPARE DATA FOR THE CSV KEYS
        $room_types = $this->Room_model->get_all_room_types($company_id);
        $r_types = $room_array = array();

        foreach ($room_types as $key => $room_type) {
            $room_array[$room_type['room_id']] = $room_type['name'];
            $r_types[$room_type['room_type_id']] = $room_type['name'];
        }
        $states = array(
            "-1" => "All",
            '0' => "Confirmed",
            '1' => "In-House",
            '2' => "Checked-out",
            '3' => "Out of Order",
            '4' => "Cancelled",
            "5" => "No Show",
            '6' => "Deleted",
            '7' => "Unconfirmed",
            '10' => "Departure",
            '11' => "Arrivals",
        );
        

        foreach ($data['bookings'] as $key => $booking) {
            $booking_data = [];
            $booking_data['r_name'] = $booking['room_id'] ? $room_array[$booking['room_id']] : $r_types[$booking['brh_room_type_id']];
            $data['bookings'][$key]['customer_fields'] = isset($booking['booking_customer_id']) ? $this->Customer_model->get_customer_fields($booking['booking_customer_id']) : null;

            // foreach ($data['common_customer_fields'] as $id => $field) {
            //     if (isset($field['show_on_in_house_report']) && $field['show_on_in_house_report']) {
            //         $data['bookings'][$key]['customer_common_fields'][$id] = (isset($data['bookings'][$key][$common_customer_fields[$id]]) && $data['bookings'][$key][$common_customer_fields[$id]]) ? $data['bookings'][$key][$common_customer_fields[$id]] : '';
            //     }
            // }

            // $staying_customer_ids = explode(',', $data['bookings'][$key]['staying_customer_id']);

            // $customer_id = $booking['booking_customer_id'];

            // foreach ($staying_customer_ids as $key1 => $cust_id) {
            //     $cust_ids = isset($cust_id) ? $this->Customer_model->get_customer_fields($cust_id) : null;

            //     foreach ($cust_ids as $key2 => $val2) {
            //         $data['bookings'][$key]['customer_fields'][$key2] = (($cust_ids[$key2]) ? $data['bookings'][$key]['customer_fields'][$key2] . ',' . $cust_ids[$key2] : (isset($data['bookings'][$key]['customer_fields'][$key2]) && ($data['bookings'][$key]['customer_fields'][$key2]) ? $data['bookings'][$key]['customer_fields'][$key2] : ''));
            //     }
            // }


            foreach ($data['common_customer_fields'] as $id => $field) {
                if (isset($field['show_on_in_house_report']) && $field['show_on_in_house_report']) {
                    $data['bookings'][$key]['customer_common_fields'][$id] = 
                        (!empty($data['bookings'][$key][$common_customer_fields[$id]])) 
                        ? $data['bookings'][$key][$common_customer_fields[$id]] 
                        : '';
                }
            }

            $staying_customer_ids = explode(',', $data['bookings'][$key]['staying_customer_id']);

            foreach ($staying_customer_ids as $customer_id) {
                $customer_id = trim($customer_id);
                if (!$customer_id) continue;

                if (isset($cached_customer_fields[$customer_id])) {
                    $cust_ids = $cached_customer_fields[$customer_id];
                } else {
                    $cust_ids = $this->Customer_model->get_customer_fields($customer_id);
                    $cached_customer_fields[$customer_id] = $cust_ids;
                }

                if ($cust_ids) {
                    foreach ($cust_ids as $key2 => $val2) {
                        // make sure it's always an array
                        if (!isset($data['bookings'][$key]['customer_fields'][$key2])) {
                            $data['bookings'][$key]['customer_fields'][$key2] = [];
                        } elseif (!is_array($data['bookings'][$key]['customer_fields'][$key2])) {
                            $data['bookings'][$key]['customer_fields'][$key2] = 
                                [$data['bookings'][$key]['customer_fields'][$key2]];
                        }

                        if (!in_array($val2, $data['bookings'][$key]['customer_fields'][$key2])) {
                            $data['bookings'][$key]['customer_fields'][$key2][] = $val2;
                        }
                    }
                }
            }

            // Convert arrays to comma-separated strings (unique values only)
            if (isset($data['bookings'][$key]['customer_fields'])) {
                foreach ($data['bookings'][$key]['customer_fields'] as $fieldKey => $vals) {
                    if (is_array($vals)) {
                        $data['bookings'][$key]['customer_fields'][$fieldKey] = implode(', ', array_unique($vals));
                    }
                }
            }

            $booking_fields_values = explode(',', $data['bookings'][$key]['booking_custom_field_value']);

            $booking_fields_ids = explode(',', $data['bookings'][$key]['booking_field_id']);

            $booking_custom_fields_array = array();

            for ($i = 0; $i < count($booking_fields_ids); $i++) {
                $booking_custom_fields_array[trim($booking_fields_ids[$i])] = isset($booking_fields_values) && isset($booking_fields_values[$i]) &&
                $booking_fields_values && $booking_fields_values[$i] ? trim($booking_fields_values[$i]) : '';
            }
            $data['bookings'][$key]['booking_custom_fields'] = $booking_custom_fields_array ? $booking_custom_fields_array : null;

            // specific requirement from Cirque du Soleil Résidence hotel - overlaping days from both periods is No of Days.
            $date1 = date_create(date("Y-m-d", strtotime($booking['check_in_date'])));
            $date2 = date_create(date("Y-m-d", strtotime($booking['check_out_date'])));
            $no_of_days = date_diff($date1, $date2);
            $data['bookings'][$key]['no_of_days'] = $no_of_days->format("%a");

            // start for get the sub total, tax total and grand total charges

            if($company_id == 2733) {

                $booking_id = $booking['booking_id'];
                $charges  = $this->Charge_model->get_charges($booking_id);

                // and invoice currently viewing transactions for 'booking customer'
                if(!$company_details['hide_forecast_charges'])
                {
                    
                    if (($booking['booking_customer_id'] == $customer_id || $customer_id == null))
                    {
                        $charges = array_merge($charges, $this->forecast_charges->_get_forecast_charges($booking_id, false));
                        $charges = array_merge($charges, $this->forecast_charges->_get_forecast_extra_charges($booking_id, false));
                        if(isset($data['folios'][0])) {
                            $data['folios'][0]['charge_count'] = count($charges);
                        }
                    }
                    elseif(isset($data['folios'][0]))
                    {
                        $forecast_charges = $this->forecast_charges->_get_forecast_charges($booking_id);
                        $forecast_charges = array_merge($forecast_charges, $this->forecast_charges->_get_forecast_extra_charges($booking_id, false));
                        $data['folios'][0]['charge_count'] = count($forecast_charges);
                    }
                }
                // assign taxes to charges
                $taxes_cache = array();
                foreach ($charges as $index => $charge) {
                    if (isset($taxes_cache[$charge['charge_type_id'] .'-'. $charge['amount']])) {
                        $charges[$index]['taxes'] = $taxes_cache[$charge['charge_type_id'] .'-'. $charge['amount']];
                    } else {
                        $charges[$index]['taxes'] = $this->Charge_type_model->get_taxes($charge['charge_type_id'], $charge['amount']);
                        $taxes_cache[$charge['charge_type_id'] .'-'. $charge['amount']] = $charges[$index]['taxes'];
                    }
                }
                $taxes_cache = array(); // release memory
                
                // $data['charges']  = $charges;
                $payments = $this->Reservation_booking_model->get_payments($booking_id, $customer_id);
                if($payments){
                    $total_amount = 0;
                    foreach($payments as $index => $payment){
                        $payments[$index]['remaining_amount'] = '';
                        if($payment['payment_status'] == 'charge' ||$payment['payment_status'] == NULL ){
                            $total_amount = $payment['amount'];
                            $charge_id = $payment['gateway_charge_id'];
                            $partial_payments = isset($charge_id) ? $this->Reservation_booking_model->get_partial_refunds_by_charge_id($charge_id) : null;

                            $total_partial_amount = 0;
                            if(!empty($partial_payments)){
                                foreach($partial_payments as $partial_payment){
                                    $total_partial_amount += $partial_payment['amount'];
                                }
                                $payments[$index]['remaining_amount'] = $total_amount + $total_partial_amount;
                            }
                        }
                    }
                }

                $data['bookings'][$key]['payments'] = $payments;

                $charge_sub_total = $charge_tax_total = $charge_final_total = $charge_s_total = $charge_t_total = $charge_f_total = 0;
                $payment_method = null;

                if (isset($charges)):
                    foreach($charges as $charge):
                        $rate = (float)$charge['amount'];
                        // $charge_sub_total += (float)$charge['amount'];

                        $combined_tax = 0;

                        if (isset($charge['taxes'])) {
                            foreach ($charge['taxes'] as $tax) {
                                if ($tax['is_percentage'] == 1)
                                {
                                    if($tax['is_tax_inclusive'] == 1)
                                    {
                                        $tax_amount = (float)$charge['amount'] - ($rate / (1 + ((float)$tax['tax_rate'] * 0.01)));
                                        $combined_tax = $combined_tax;
                                    }
                                    else
                                    {
                                        $tax_amount = (float)$tax['tax_rate'] * $rate * 0.01;
                                        $combined_tax = $combined_tax + $tax_amount;
                                    }
                                }
                                else
                                {
                                    $tax_amount = (float)$tax['tax_rate'];
                                    $combined_tax = $combined_tax + $tax_amount;
                                }

                                $charge_tax_total += number_format($tax_amount, 2, ".", ",");
                            }
                        }

                        $charge_final_total += number_format($rate + $combined_tax, 2, ".", ",");

                    endforeach;
                endif;

                $charge_s_total += $charge_final_total - $charge_tax_total;
                $charge_t_total += $charge_tax_total;
                $charge_f_total += $charge_final_total;



                $pay_by_card = $pay_by_cash = false;
                
                if($payments){
                    foreach($payments as $book_pay){
                        if(
                            isset($book_pay['gateway_charge_id']) &&
                            $book_pay['gateway_charge_id']
                        ) {
                            $pay_by_card = true;
                        } else {
                            $pay_by_cash = true;
                        }
                    }
                }

                if($pay_by_card && $pay_by_cash){
                    $payment_method = "Cash/Card";
                }
                else if($pay_by_card && !$pay_by_cash){
                    $payment_method = "Card";
                }
                else if(!$pay_by_card && $pay_by_cash){
                    $payment_method = "Cash";
                }

            }

            // end for get the sub total, tax total and grand total charges

            $booking_row = [];
            if (in_array('created_date', $settings)) {
                $booking_row[] = date('Y-m-d', strtotime($booking['created_date']));
            }

            if (in_array('check_in_date', $settings)) {
                $booking_row[] = ($this->enable_hourly_booking == 1 ? date('Y-m-d h:i A', strtotime($booking['check_in_date'])) : ($booking['check_in_date'] ? date('Y-m-d', strtotime($booking['check_in_date'])) : ''));
            }
            if (in_array('check_out_date', $settings)) {
                $booking_row[] = ($this->enable_hourly_booking == 1 ? date('Y-m-d h:i A', strtotime($booking['check_out_date'])) : ($booking['check_out_date'] ? date('Y-m-d', strtotime($booking['check_out_date'])) : ''));
            }
            if (in_array('booking_id', $settings)) {
                $booking_row[] = $booking['booking_id'];
            }
            if (in_array('balance', $settings)) {
                $booking_row[] = $booking['balance'];
            }
            if (in_array('customer_name', $settings)) {
                $cust_names = get_customer_names($booking['customer_name'], $booking['staying_customers'], $booking['guest_count']);
                $booking_row[] = $cust_names; //$booking['customer_name'];
            }
            if (in_array('email', $settings)) {
                $booking_row[] = $booking['email'];
            }
            if (in_array('phone', $settings)) {
                $booking_row[] = $booking['phone'];
            }
            if (in_array('address', $settings)) {
                $booking_row[] = $booking['address'];
            }
            if (in_array('state', $settings)) {
                $booking_row[] = $booking['region'];
            }
            if (in_array('city', $settings)) {
                $booking_row[] = $booking['city'];
            }
            if (in_array('postal_code', $settings)) {
                $booking_row[] = $booking['postal_code'];
            }
            if (in_array('country', $settings)) {
                $booking_row[] = $booking['country'];
            }
            if (in_array('room', $settings)) {
                $booking_row[] = $booking['room_name'];
            }
            
            if (in_array('no_of_days', $settings)) {
                $booking_row[] = $data['bookings'][$key]['no_of_days'];
            }
            
            if (in_array('adult_count', $settings)) {
                $booking_row[] = $booking['adult_count'];
            }
            if (in_array('children_count', $settings)) {
                $booking_row[] = $booking['children_count'];
            }
            if (in_array('booking_source', $settings)) {
                $booking_row[] = is_numeric($booking['booking_source']) ? (isset($common_booking_sources[$booking['booking_source']]) ? $common_booking_sources[$booking['booking_source']] : "") : $booking['booking_source'];
            }
            // CM PARTNER PENDING
            if (in_array('ota_confirmtion', $settings)) {
                $booking_row[] = ($booking['is_ota_booking'] != 0) ? "Confirmed" : "";
            }
            if (in_array('booked_by', $settings)) {
                $booking_row[] = $booking['first_name'] . " " . $booking['last_name'];
            }
            if (in_array('rate', $settings)) {
                $booking_row[] = ($booking['rate'] != 0) ? number_format($booking['rate'], 2, ".", ",") : "";
            }
            if (in_array('rate_plan', $settings)) {
                $booking_row[] = $booking['rate_plan_name'];
            }
            if (in_array('status', $settings)) {
                $status = $states[$booking['state']];
                if ($booking['booking_deleted'] == 1) {
                    $status = "Deleted";
                } elseif ($booking['state'] == 0) {
                    $status = "Reservation";
                }
                $booking_row[] = $status;
            }
            if (in_array('booking_notes_desc', $settings)) {
                $booking_row[] = $booking['booking_notes'];
            }
            if (in_array('customer_type', $settings)) {
                $booking_row[] = $booking['customer_type_name'];
            }
            if (in_array('total_reservation_amount', $settings)) {
                $booking_row[] = $booking['balance'] + $booking['payment_total'];
            }
            if (in_array('paid_amount', $settings)) {
                $booking_row[] = $booking['payment_total'];
            }
            
            if($company_id == 2733) {

                if (in_array('charge_sub_total', $settings)) {
                    $booking_row[] = $charge_s_total;
                }
                if (in_array('charge_tax_total', $settings)) {
                    $booking_row[] = $charge_t_total;
                }
                if (in_array('charge_final_total', $settings)) {
                    $booking_row[] = $charge_f_total;
                }
                if (in_array('payment_method', $settings)) {
                    $booking_row[] = $payment_method;
                }
            }

            // COMMON CUSTOMER FIELDS
            if (count($data['common_customer_fields']) != 0) {
                foreach ($data['common_customer_fields'] as $fk => $fields) {
                    if (isset($fields['show_on_in_house_report']) && $fields['show_on_in_house_report'] == 1
                        && !in_array($fields['name'], ['Notes', 'Name', 'Customer Type'])
                        && in_array(preg_replace("/^'|[^A-Za-z0-9\'-]|'?/", '', $fields['name']), $settings)
                    ) {
                        $booking_row[] =
                        isset($data['bookings'][$key]['customer_common_fields'][$fk]) ? $data['bookings'][$key]['customer_common_fields'][$fk] : "";
                    }
                }
            }
            // CUSTOMER FIELDS
            if (isset($customer_fields) && count($customer_fields) != 0) {
                foreach ($customer_fields as $fields) {
                    if ($fields['show_on_in_house_report'] == 1
                        && in_array(preg_replace("/^'|[^A-Za-z0-9\'-]|'?/", '', $fields['name']), $settings)) {
                        $booking_row[] =
                        isset($data['bookings'][$key]['customer_fields'][$fields['id']]) ? $data['bookings'][$key]['customer_fields'][$fields['id']] : "";
                    }
                }
            }

            // BOOKING FIELDS
            if (isset($booking_fields) && count($booking_fields) != 0) {
                foreach ($booking_fields as $fields) {
                    if (in_array(preg_replace("/^'|[^A-Za-z0-9\'-]|'?/", '', $fields['name']), $settings)) {
                        $booking_row[] =
                        isset($data['bookings'][$key]['booking_custom_fields'][$fields['id']]) ? $data['bookings'][$key]['booking_custom_fields'][$fields['id']] : "";
                    }
                }
            }

            $bookings[] = $booking_row;
        }

        force_download_csv($bookings, "reservation_report.csv");
    }

    public function group_report($from_date = null, $to_date = null, $group_id = null)
    {
        //get user's shift information
        $date = (isset($from_date)) ? $from_date : $this->selling_date;
        $from_date = (isset($from_date)) ? $from_date : date('Y-m-1');
        $to_date = (isset($to_date)) ? $to_date : date('Y-m-d');
        $data['date'] = $date;
        $data['from_date'] = $from_date;
        $data['to_date'] = $to_date;
        $data['hotel_name'] = $this->company_name;

        $filters = array(
            'start_date' => $from_date,
            'end_date' => $to_date,
        );

        if ($group_id != '') {
            $filters['group_id'] = $group_id;
        }

        $company_id = $this->session->userdata('current_company_id');
        $data['bookings'] = $this->Reservation_booking_model->get_group_bookings($filters);
        $data['group_ids'] = $this->Reservation_booking_model->get_group_ids($from_date, $to_date);
        foreach ($data['bookings'] as $key => $booking) {
            $data['bookings'][$key]['customer_fields'] = isset($booking['booking_customer_id']) ? $this->Customer_model->get_customer_fields($booking['booking_customer_id']) : null;
        }
        $data['customer_fields'] = $this->Customer_field_model->get_customer_fields($company_id);
        $data['main_content'] = '../extensions/' . $this->module_name . '/views/group_report';

        $this->template->load('bootstrapped_template', null, $data['main_content'], $data);

    }

    public function download_group_csv_export($from_date = null, $to_date = null, $group_id = null)
    {

        $this->load->helper('download');
        $this->load->helper('customer_name');
        $this->ci->load->library('rate');

        $date = (isset($from_date)) ? $from_date : $this->selling_date;
        $from_date = (isset($from_date)) ? $from_date : date('Y-m-1');
        $to_date = (isset($to_date)) ? $to_date : date('Y-m-d');
        $group_id = (isset($group_id)) ? $group_id : '';
        $data['date'] = $date;
        $data['from_date'] = $from_date;
        $data['to_date'] = $to_date;
        $data['group_id'] = $group_id;

        $filters = array(
            'start_date' => $from_date,
            'end_date' => $to_date,
            'group_id' => $group_id,
        );

        $company_id = $this->session->userdata('current_company_id');
        $data['bookings'] = $this->Reservation_booking_model->get_group_bookings($filters);

        $csv_keys = array(
            "Group ID",
            "Group Name",
            "Date",
            "Booking Id",
            "Guest name",
            "State",
            "Booking Notes",
        );

        $bookings = array($csv_keys);
        foreach ($data['bookings'] as $key => $booking) {
            if ($booking['is_group_booking'] != '') {
                $booking_row = array();
                $booking_row[] = $booking['is_group_booking'] ? $booking['is_group_booking'] : "";
                $booking_row[] = $booking['group_name'] ? $booking['group_name'] : "";
                $booking_row[] = $booking['state'] == 10 ? $booking['check_out_date'] : $booking['check_in_date'];
                $booking_row[] = $booking['booking_id'] ? $booking['booking_id'] : "";
                $booking_row[] = get_customer_names($booking['customer_name'], $booking['guest_name'], $booking['guest_count']);
                $booking_row[] = $booking['state'] ? $booking['state'] : "";
                $booking_row[] = $booking['booking_notes'] ? $booking['booking_notes'] : "";

                $bookings[] = $booking_row;
            }
        }
        force_download_csv($bookings, "group_report.csv");
    }
    
    function show_inhouse_report($from_date = null, $to_date = null, $booking_status = 'checking_in')
    {
        //get user's shift information
        $date = (isset($from_date))?$from_date:$this->selling_date;
        $from_date = (isset($from_date))?$from_date:date('Y-m-1');
        $to_date = (isset($to_date))?$to_date:date('Y-m-d');
        $data['date'] = $date;
        $data['from_date'] = $from_date;
        $data['to_date'] = $to_date;
        $data['hotel_name'] = $this->company_name;   
        
        $filters = array(
            'start_date' => $from_date,
            'end_date' => $to_date
        );
        
        $data['selected_state'] = 'checking_in';
        $filters['state'] = "active";

        $filters['booking_status'] = 'checking_in';    

        if ($booking_status == 'checking_out')
        {
            $filters['booking_status'] = 'checking_out';
            $data['selected_state'] = 'checking_out';
        }
        
        $filters['include_customer_type'] = true;
        $filters['include_booking_fields'] = true;  

        $company_id = $this->session->userdata('current_company_id');
        $data['bookings'] = $this->Reservation_booking_model->get_bookings($filters, null, null, true, true);
        $data['company_details'] = $this->Company_model->get_company($company_id);

        $data['common_customer_fields'] = $this->Customer_field_model->get_common_customer_fields_settings($this->company_id);
        $data['customer_common_fields'] = json_decode(COMMON_CUSTOMER_FIELDS, true);
        
        $common_customer_fields = json_decode(COMMON_CUSTOMER_DB_FIELDS, true);
        foreach($data['customer_common_fields'] as $key => $field)
        {
            $data['common_customer_fields'][$key]['name'] = $field;
        }

        $room_types = $this->Room_model->get_all_room_types($company_id);
        $r_types = $room_array = array();
        
        foreach($room_types as $key => $room_type)
        {
            $room_array[$room_type['room_id']] = $room_type['name'];
            $r_types[$room_type['room_type_id']] = $room_type['name'];
        }
        foreach($data['bookings'] as $key => $booking)
        {
            $data['bookings'][$key]['r_name'] = $booking['room_id'] ? $room_array[$booking['room_id']] : $r_types[$booking['brh_room_type_id']];
            $data['bookings'][$key]['customer_fields'] = isset($booking['booking_customer_id']) ? $this->Customer_model->get_customer_fields($booking['booking_customer_id']) : null;

            
            foreach($data['common_customer_fields'] as $id => $field) {
                if(isset($field['show_on_in_house_report']) && $field['show_on_in_house_report']) {
                    $data['bookings'][$key]['customer_common_fields'][$id] = (isset($data['bookings'][$key][$common_customer_fields[$id]]) && $data['bookings'][$key][$common_customer_fields[$id]]) ? $data['bookings'][$key][$common_customer_fields[$id]] : '';
                }
            }

            $staying_customer_ids = explode(',', $data['bookings'][$key]['staying_customer_id']);
            
            foreach($staying_customer_ids as $key1=>$customer_id)
            {
                $cust_ids = isset($customer_id) ? $this->Customer_model->get_customer_fields($customer_id) : null;
                
                foreach($cust_ids as $key2 => $val2){
                    $data['bookings'][$key]['customer_fields'][$key2] = (($cust_ids[$key2]) ? $data['bookings'][$key]['customer_fields'][$key2].','. $cust_ids[$key2] : (isset($data['bookings'][$key]['customer_fields'][$key2]) && ($data['bookings'][$key]['customer_fields'][$key2]) ? $data['bookings'][$key]['customer_fields'][$key2] : ''));
                }
            }
            $booking_fields = explode(',', $data['bookings'][$key]['booking_custom_field_id_value']);
            
            $booking_custom_fields_array = array();

            foreach ($booking_fields as $value) {
                $fields = explode('::',$value);
                $booking_fields_ids = $fields[0];
                $booking_fields_values = isset($fields[1]) && $fields[1] ? $fields[1] : '';

                $booking_custom_fields_array[$booking['booking_id']][$booking_fields_ids] = $booking_fields_values;
            }

            $data['bookings'][$key]['booking_custom_fields'] = $booking_custom_fields_array[$booking['booking_id']] ? $booking_custom_fields_array[$booking['booking_id']] : null;
            
            // specific requirement from Cirque du Soleil Résidence hotel - overlaping days from both periods is No of Days.             
            $date1 = date_create(date("Y-m-d", strtotime($booking['check_in_date'])));
            $date2 = date_create(date("Y-m-d", strtotime($booking['check_out_date'])));
            $no_of_days = date_diff($date1, $date2);
            $data['bookings'][$key]['no_of_days'] = $no_of_days->format("%a");
        }   

        $data['customer_fields'] = $this->Customer_field_model->get_customer_fields($company_id);
        $data['booking_fields'] = $this->Booking_field_model->get_booking_fields($company_id);

        // $data['css_files'][] = base_url().auto_version('css/report.css');
        // $data['css_files'][] = base_url() . auto_version('css/booking/booking_main.css');
        
        // $data['js_files'] = array(
        //     base_url().'js/moment.min.js',
        // );
        $data['main_content'] = '../extensions/' . $this->module_name . '/views/in_house';
        $this->template->load('bootstrapped_template', null, $data['main_content'], $data);

    }

    function download_inhouse_csv_export($from_date = null, $to_date = null, $state = INHOUSE)
    {        
        
        $this->load->helper('download');
        $this->load->helper('customer_name');
        $this->ci->load->library('rate');
        
        $date = (isset($from_date))?$from_date:$this->selling_date;
        $from_date = (isset($from_date))?$from_date:date('Y-m-1');
        $to_date = (isset($to_date))?$to_date:date('Y-m-d');
        $data['date'] = $date;
        $data['from_date'] = $from_date;
        $data['to_date'] = $to_date;
        $data['hotel_name'] = $this->company_name;   
        
        $filters = array(
            'start_date' => $from_date,
            'end_date' => $to_date
        );
        
        $data['selected_state'] = $state;
        $filters['state'] = "active";

        $filters['include_customer_type'] = true;
        
        $company_id = $this->session->userdata('current_company_id');
        $data['bookings'] = $this->Reservation_booking_model->get_bookings($filters, null, null, true, true);
        $data['company_details'] = $this->Company_model->get_company($company_id);

        $data['common_customer_fields'] = $this->Customer_field_model->get_common_customer_fields_settings($this->company_id);
        $data['customer_common_fields'] = json_decode(COMMON_CUSTOMER_FIELDS, true);
        
        $common_customer_fields = json_decode(COMMON_CUSTOMER_DB_FIELDS, true);

        foreach($data['customer_common_fields'] as $key => $field)
        {
            $data['common_customer_fields'][$key]['name'] = $field;
        }
        
        foreach($data['bookings']  as $key => $booking)
        {
            $data['bookings'][$key]['customer_fields'] = isset($booking['booking_customer_id']) ? $this->Customer_model->get_customer_fields($booking['booking_customer_id']) : null;
            $staying_customer_ids = explode(',', $data['bookings'][$key]['staying_customer_id']);

            foreach($data['common_customer_fields'] as $id => $field) {
                if(isset($field['show_on_in_house_report']) && $field['show_on_in_house_report']) {
                    $data['bookings'][$key]['customer_common_fields'][$id] = (isset($data['bookings'][$key][$common_customer_fields[$id]]) && $data['bookings'][$key][$common_customer_fields[$id]]) ? $data['bookings'][$key][$common_customer_fields[$id]] : '';
                }
            }
            
            foreach($staying_customer_ids as $key1 => $customer_id)
            {
                $cust_ids = isset($customer_id) ? $this->Customer_model->get_customer_fields($customer_id) : array();
                
                foreach($cust_ids as $key2 => $val2){
                    $data['bookings'][$key]['customer_fields'][$key2] = (($cust_ids[$key2]) ? $data['bookings'][$key]['customer_fields'][$key2].','. $cust_ids[$key2] : (isset($data['bookings'][$key]['customer_fields'][$key2]) && ($data['bookings'][$key]['customer_fields'][$key2]) ? $data['bookings'][$key]['customer_fields'][$key2] : ''));
                }
            }
            
            // specific requirement from Cirque du Soleil Résidence hotel - overlaping days from both periods is No of Days.             
            $date1 = date_create(date("Y-m-d", strtotime($booking['check_in_date'])));
            $date2 = date_create(date("Y-m-d", strtotime($booking['check_out_date'])));
            $no_of_days = date_diff($date1, $date2);
            $data['bookings'][$key]['no_of_days'] = $no_of_days->format("%a");
        }
        $customer_fields = $this->Customer_field_model->get_customer_fields($company_id);
        
        krsort($data['common_customer_fields']);
        
        $common_booking_sources = json_decode(COMMON_BOOKING_SOURCES, true);
        $states = Array(
                            "-1" => "All",
                            RESERVATION => "Reservation",
                            INHOUSE => "Checked-in",
                            CHECKOUT => "Checked-out",
                            OUT_OF_ORDER => "Out of Order"
                        );
        $inhouse_settings = $data['company_details']['inhouse_settings'];
        if($inhouse_settings == "") {
            $inhouse_settings = "booking_id,status,room,check_in_date,check_out_date,customer_names,customer_email,customer_notes,customer_type";
        }
        $settings = explode(',', $inhouse_settings);
        
        $csv_keys = array();

        $csv_lookup_keys = array(
            "booking_id" => "Booking Id",
            "adult_count" => "Number of Adults",
            "children_count" => "Number Of Children",
            "status" => "Status",
            "room" => "Room",
            "room_type" => "Room Type",
            "check_in_date" => "Check-in date",
            "check_out_date" => "Check-Out date",
            "no_of_days" => "No Of Days",
            "unit_price" => "Unit Price (price by Night)",
            "booking_source" => "Booking Source",
            "customer_names" => "Customer name",
            "customer_email" => "Customer email",
            "customer_type" => "Customer type",
            "customer_notes" => "Customer Notes",
            "payment" => "Payment",
            "group_name" => "Group Name",
            "rate" => "Rate",
            "rate_plan" => "Rate plan"
        );

        foreach($csv_lookup_keys as $key => $value) {
            if(in_array($key,$settings)){
                $csv_keys[] = $value;
            }
         }
      
         if(count($data['common_customer_fields']) !=0){
            foreach($data['common_customer_fields'] as $fields){
                if(isset($fields['show_on_in_house_report']) && $fields['show_on_in_house_report'] == 1
                    && (!in_array($fields['name'], ['Notes', 'Name', 'Customer Type']))
                ) {
                        $csv_keys[] = ($fields['name'] != 'Name' && $fields['name'] != 'Customer Type' && $fields['name'] != 'Notes') ? $fields['name'] : '';
                }
            }
        }
        
        if(isset($customer_fields) && count($customer_fields) !=0) {
            foreach($customer_fields as $fields){
                if($fields['show_on_in_house_report']==1 && in_array(preg_replace("/^'|[^A-Za-z0-9\'-]|'?/", '', $fields['name']), $settings)){
                        $csv_keys[] = $fields['name'];
                }
            }
        }
        
        $booking_source_settings = $this->Booking_source_model->get_common_booking_sources_settings($this->company_id);
        $room_types = $this->Room_model->get_all_room_types($company_id);
        $r_types = $room_array = array();
        foreach($room_types as $key => $room_type)
        {
            $room_array[$room_type['room_id']] = $room_type['name'];
            $r_types[$room_type['room_type_id']] = $room_type['name'];
        }
        $bookings = array($csv_keys);

        foreach($data['bookings'] as $key => $booking){
            
            if ($booking['state'] == OUT_OF_ORDER)
                continue;
            
            $date1 = date_create($booking['check_in_date']);
            $date2 = date_create($booking['check_out_date']);
            $diff = date_diff($date1, $date2);       

            $days = $diff->format("%a");
            $amount = $booking['rate'];
            if ($booking['use_rate_plan'] && $booking['rate_plan_id'] != '0')
            {
                $rate_array = $this->ci->rate->get_rate_array(
                                                $booking['rate_plan_id'], 
                                                $booking['check_in_date'], 
                                                $booking['check_out_date'], 
                                                $booking['adult_count'], 
                                                $booking['children_count']
                                            );
                if (isset($rate_array[0]))
                    $amount = $rate_array[0]['rate'];
            }
            
            $daily_rate = round(($amount), 2, PHP_ROUND_HALF_UP);
            if($booking['pay_period'] == WEEKLY){
                $daily_rate = round(($amount / 7), 2, PHP_ROUND_HALF_UP);
            }
            elseif($booking['pay_period'] == MONTHLY){
                $daily_rate = round(($amount / 30), 2, PHP_ROUND_HALF_UP);
            }
            
            $booking_row = array();
            if(in_array('booking_id', $settings)) {
                $booking_row[] = $booking['booking_id'];
            }
            if(in_array('adult_count', $settings)) {
                $booking_row[] = $booking['adult_count'];
            }
            if(in_array('children_count', $settings)) {
                $booking_row[] = $booking['children_count'];
            }
            if(in_array('status', $settings)) {
                $booking_row[] = isset($states[$booking['state']]) && $states[$booking['state']] ? $states[$booking['state']] : "";
            }
            if(in_array('room', $settings)) {
                $booking_row[] = $booking['room_name'] ? $booking['room_name'] : 'Not Assigned';
            }
            if(in_array('room_type', $settings)) {
                $booking_row[] = $booking['room_id'] ? $room_array[$booking['room_id']] : $r_types[$booking['brh_room_type_id']];
            }
            if(in_array('check_in_date', $settings)) {
                $booking_row[] = $booking['check_in_date'];
            }
            if(in_array('check_out_date', $settings)) {
                $booking_row[] = $booking['check_out_date'];
            }
            if(in_array('no_of_days', $settings)) {
                $booking_row[] = $booking['no_of_days'];
            }
            if(in_array('unit_price', $settings)) {
                $booking_row[] = $daily_rate;
            }
            if(in_array('booking_source', $settings)) {
                $booking_row[] = is_numeric($booking['source']) ? (isset($common_booking_sources[$booking['source']]) ? $common_booking_sources[$booking['source']] : "") : $booking['source'];
            }
            if(in_array('customer_names', $settings)) {
                $booking_row[] = get_customer_names($booking['customer_name'], $booking['staying_customers'], $booking['guest_count']);
            }
            if(in_array('customer_email', $settings)) {
                $booking_row[] = $booking['email'];
            }
            if(in_array('customer_type', $settings)) {
                $booking_row[] = $booking['customer_type_name'];
            }
            if(in_array('customer_notes', $settings)) {
                $booking_row[] = $booking['booking_notes'];
            }
            if(in_array('payment', $settings)) {
                $booking_row[] = $booking['payment_total'];
            }

            if(count($data['common_customer_fields']) !=0) { 
                foreach ($data['common_customer_fields'] as $id => $field) {
                    if(isset($field['show_on_in_house_report']) && $field['show_on_in_house_report'] == 1
                        && (!in_array($field['name'], ['Notes', 'Name', 'Customer Type']))
                    ) {
                        $booking_row[] = ($field['name'] != 'Name' && $field['name'] != 'Customer Type' && $field['name'] != 'Notes') ? ((isset($booking['customer_common_fields'][$id]) ? $booking['customer_common_fields'][$id] : "")) : '';
                    }
                }
            }
            
            if(isset($customer_fields) && count($customer_fields) !=0) {
                foreach ($customer_fields as $field) {
                    if ($field['show_on_in_house_report'] == 1 && in_array(preg_replace("/^'|[^A-Za-z0-9\'-]|'?/", '', $field['name']), $settings)) {
                        $booking_row[] = (isset($booking['customer_fields'][$field['id']]) ? $booking['customer_fields'][$field['id']] : "");
                    }
                }
            }
            
            $bookings [] = $booking_row;
        }
        force_download_csv($bookings, "inhouse_report.csv");
    }
    
    function set_inhouse_column_settings_AJAX(){
        $columns = $this->input->post('columns');
        $this->Company_model->update_company_admin_panel_info($this->company_id, array('inhouse_settings' => $columns));
        echo json_encode("success");
    }
 
    public function set_reservation_column_settings_AJAX()
    {
        $columns = $this->input->post('columns');
        $this->Company_model->update_company_admin_panel_info($this->company_id, array('reservation_settings' => $columns));
        echo json_encode("success");
    }

    function set_order_by($field_name,$start_date,$end_date,$book_type, $is_channel_manager = null)
    {   
        $lastUrl = base_url()."reports/reservation/reservation_report/";
        // prx($lastUrl); die;
        $param = $start_date."/".$end_date."/".$book_type;

        // print_r($start_date.$end_date.$book_type); 
        // Assign which field the ordering will be based on
        $this->session->set_userdata('reservation_order_by', $field_name);

                // Choose ascending/descending order depending on session variable
                $customer_order = $this->session->userdata('reservation_order');
        if (isset($customer_order))
        {
            if ($customer_order == 'ASC')
                $this->session->set_userdata('reservation_order', 'DESC');
            else {
                $this->session->set_userdata('reservation_order', 'ASC');
            }
        } else {
            $this->session->set_userdata('customer_order', 'DESC');
        }
        // prx($this->session->all_userdata()); die;
        if(isset($is_channel_manager))
        {
            // redirect('/reports/reservation/show_reservation_report_cm/');
            redirect($lastUrl);

        }
        else
        {
            redirect($lastUrl.$param);
        }
        
            
    }
    
}
